﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class WagerRaceDifficultyConfiguration : ConfigurationElement
{
    public int MinWagerCap { get; private set; }
    public int MaxWagerCap { get; private set; }
    public float OddsMultiplierLowerRange { get; private set; }
    public float OddsMultiplierUpperRange { get; private set; }

    public WagerRaceDifficultyConfiguration(string id) : base(id)
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            MinWagerCap = Convert.ToInt32(configElem.Element("MinWagerCap").Value);
            MaxWagerCap = Convert.ToInt32(configElem.Element("MaxWagerCap").Value);
            OddsMultiplierLowerRange = Convert.ToSingle(configElem.Element("OddsMultiplierLowerRange").Value);
            OddsMultiplierUpperRange = Convert.ToSingle(configElem.Element("OddsMultiplierUpperRange").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing wager race difficulty configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
